/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/
#ifndef debugger_h
#define debugger_h
#include "config.h"
#ifdef PAS_DEBUGGER

#include "aum/word.h"
#include "aum/messagetag.h"
#include "aum/message.h"
#include "aum/globlmsg.h"
#include "aum/parallel.h"

#define	 BEFORE_MAKE_SHELL
#define PT_ENV	"A'UmDB-Env> "
#define PT_NORMAL   "A'UmDB> "
#define PT_EXECUTE  "A'UmDB-Exe> "

#define ErrM_TOP_ONLY	    "Used Only Top level"
#define ErrM_EXEC_ONLY	    "Available only in break mode"
#define ErrM_UNDEFINED	    "Undefined command"
#define ErrM_SORRY	    "not implemented"
#define ErrUnKnownCLASS	    "Undefined Class"
#define ErrUnKnownPID	    "Undefined ProtocolID"
#define ErrUnKnownOBJECT    "Unknown Object"
#define ErrUnKnownMETHOD    "Undefined Method"
#define ErrUnKnownSLOT	    "Undefined Slot"

typedef enum  {
  ASSEMBLE	 , // Message id send to scheduler
  DBPCLASS	 ,
  DBPOBJECT	 ,
  DBPMETHOD	 ,
  DBPSLOT	 ,
  DBPPID	 ,
  DTRCLASS	 ,
  DTROBJECT	 ,
  DTRMETHOD	 ,
  DTRSLOT	 ,
  DTRPID	 ,
  UBPCLASS	 ,
  UBPOBJECT	 ,
  UBPMETHOD	 ,
  UBPSLOT	 ,
  UBPPID	 ,
  UTRCLASS	 ,
  UTROBJECT	 ,
  UTRMETHOD	 ,
  UTRSLOT	 ,
  UTRPID	 ,
  DUMP_PID	 ,
  DUMP_CLASS	 ,
  DUMP_OBJECT	 ,
  DUMP_SCHEDULER ,
  CONTINUE	 ,
  DESCRIBE	 ,
  RUN		 ,
  STEP		 ,
  NEXTSTEP	 ,
  STEPINST	 ,
  TRACE_ON	 ,
  TRACE_OFF	 ,
  PRINT_SLOT	 ,
  OBJSTAT	 ,
  OBJWAIT	 ,
  OBJACT	 ,
  DUMP_REG	 ,
  DTROBJSLOT	 ,
  UTROBJSLOT	 ,
  DBPOBJSLOT	 ,
  UBPOBJSLOT	 ,
  DTROBJMETHOD	 ,
  UTROBJMETHOD	 ,
  DBPOBJMETHOD	 ,
  UBPOBJMETHOD	 ,
  OUTPUT	 ,
  QUIT		 ,
  //   debugger between listener
  ERECEIVE,
  TRECEIVE,
  NRECEIVE,
  WAIT_MESSAGE,
  RECD_MESSAGE,
  BREAK,
  // online help command
  CLASSES	 ,
  CLASSINFO	 ,
  METHOD_LIST	 ,
  SLOT_LIST	 ,
  INFO_PROCESSOR,
  INFO_CURRENT,
  INFO,
  HELP_OBJECT_NUMBER,
  HELP_PID,
  HELP_PROCESSOR_NUMBER,
  HELP_EXPRESSION,
  HELP_PRINT_EXPRESSION,
  HELP_PRINT_OBJECT_OUTLET,
  HELP_PRINT_OBJECT_INLET,
  HELP_PRINT_REGISTER,
  HELP_PRINT_FLAGS,
  HELP_PRINT_CLASSES,
  HELP_PRINT_ACTIVE,
  HELP_PRINT_WAITING,
  HELP_PRINT_SCHEDULER,
  HELP_PRINT_OBJECT,
  HELP_PRINT,
  HELP_BREAK,
  HELP_UNBREAK,
  HELP_TRACE,
  HELP_UNTRACE,
  HELP_OUTPUT,
  HELP_TRON,
  HELP_TROFF,
  HELP_CONTINUE,
  HELP_RUN,
  HELP_STEP,
  HELP_QUIT,
  HELP_NEXT,
  HELP_STEP_I,
  HELP_INFO_CURRENT,
  HELP_INFO_METHODS,
  HELP_INFO_SLOTS,
  HELP_INFO_PROCESSOR,
  HELP_INFO_PID,
  HELP_INFO,
  HELP,
  // illeagal code
  DEFAULT	 ,
} debugger_symbol;

typedef enum {
    TraceOn,
    TraceOff
} TraceMode;

typedef enum  {
  UnKnownClass,
  UnKnownPid,
  UnKnownObject,
  UnKnownMethod,
  UnKnownSlot,
  UnDefCommand,
  Sorry,
} ReceiveErrorCode;

typedef enum {
    Method,Slot,All
} DisplayState;

#define PACKET_SIZE 29

#endif
/*-----------------
* Local Variables:
* c-indent-level:4
* c-continued-statement-offset:4
* c-brace-offset:0
* c-imaginary-offset:0
* c-argdecl-indent:4
* c-label-offset:-4
* c++-electric-colon:t
* c++-empty-arglist-indent:nil
* c++-friend-offset:-4
* c++-member-init-indent-offset:0
* c++-continued-member-init-offset:nil
* End:
*/
#endif	/* !debugger_h */
