/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_compare_h
#define aum_compare_h

// Ӵؿη̤ѤơBOOLTRUE or BOOLFALSE ɤ֤

// Ӵؿ
extern int CompareAtom (Word, Word);
extern int CompareFixnum(Word, Word);
extern int CompareSFloat(Word, Word);
extern int CompareDFloat(Word, Word);

// Equal
inline Word Fixnum_Eq_p(Word x, Word y)
    //  x   y п򡤤Ǥʤе򤫤
{
    return CompareFixnum(x, y) == 0 ? BOOLTRUE : BOOLFALSE;
}

inline Word SFloat_Eq_p(Word x, Word y)
    // ñư x  ñư y п
    // Ǥʤе򤫤
{
    return CompareSFloat(x, y) == 0 ? BOOLTRUE : BOOLFALSE;
}

inline Word DFloat_Eq_p(Word x, Word y)
    // ư x  ư y п
    // Ǥʤе򤫤
{
    return CompareDFloat(x, y) == 0 ? BOOLTRUE : BOOLFALSE;
}

// Not Equal
inline Word Fixnum_Neq_p(Word x, Word y)
    //  x   y ʤп򡤤Ǥʤе򤫤
{
    return CompareFixnum(x, y) != 0 ? BOOLTRUE : BOOLFALSE;
}

inline Word SFloat_Neq_p(Word x, Word y)
    // ñư x  ñư y ʤп
    // 򡤤Ǥʤе򤫤
{
    return CompareSFloat(x, y) != 0 ? BOOLTRUE : BOOLFALSE;
}

inline Word DFloat_Neq_p(Word x, Word y)
    // ư x  ư y ʤп
    // 򡤤Ǥʤе򤫤
{
    return CompareDFloat(x, y) != 0 ? BOOLTRUE : BOOLFALSE;
}

// Greater Than
inline Word Fixnum_Gt_p(Word x, Word y)
    //  x   y 礭п򡤤Ǥʤе򤫤
{
    return CompareFixnum(x, y) > 0 ? BOOLTRUE : BOOLFALSE;
}

inline Word SFloat_Gt_p(Word x, Word y)
    // ñư x  ñư y 礭п
    // Ǥʤе򤫤
{
    return CompareSFloat(x, y) > 0 ? BOOLTRUE : BOOLFALSE;
}

inline Word DFloat_Gt_p(Word x, Word y)
    // ư x  ư y 礭п
    // Ǥʤе򤫤
{
    return CompareDFloat(x, y) > 0 ? BOOLTRUE : BOOLFALSE;
}


// Grater Than and Equal ////////////////////////////////////////////

inline Word Fixnum_Ge_p(Word x, Word y)
{
    return CompareFixnum(x, y) >= 0 ? BOOLTRUE : BOOLFALSE;
}

inline Word SFloat_Ge_p(Word x, Word y)
{
    return CompareSFloat(x, y) >= 0 ? BOOLTRUE : BOOLFALSE;
}

inline Word DFloat_Ge_p(Word x, Word y)
{
    return CompareDFloat(x, y) >= 0 ? BOOLTRUE : BOOLFALSE;
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_compare_h */
