/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_builtin_h
#define aum_builtin_h

#include <string.h>
#include "aum/header.h"
#include "aum/word.h"

// Double Float Object ///////////////////////////////////////////

class DFloatObject : public Header {
 private:
    double  real;

    void    Initialize (double value);
 public:
    double  GetValue ();
    void    SetValue (double value);
    void    Free ();
    int	    Copyto (Word *);
    Name    Print ();

    friend Word CopyDFloat (Word x);
    friend Word CreateDFloat (double value = 0.0);
    friend void DeleteDFloat (Word x);
    friend void PrintDFloat (Word x);
    friend int CompareDFloat (Word x, Word y);
    friend Name DFloatPrintImage (Word x);

    friend double Double2double (Word x);
    friend Word Fix2Double (Word x);
    friend Word Single2Double (Word x);
    friend Word Double2Fix (Word x);
    friend Word Double2Single (Word x);
};

inline double
DFloatObject::GetValue ()
{
    return real;
}

inline void
DFloatObject::SetValue (double v)
{
    real = v;
}

inline int
DFloatObject::Copyto (Word * to)
{
    memcpy (to, this, sizeof (*this));
    return sizeof (*this) / sizeof (Word);
}

#define DFloatObject_ptr(x)	((DFloatObject*) Pointer (x))
#define IsDFloat(x)		IsBuiltinType (x,DFLOAT)

// Class Object //////////////////////////////////////////////////

class ClassObject : public Header {
 private:
    class ClassTmpl *classtmpl;

    void    Initialize (ClassTmpl * ct);
 public:
	    ClassTmpl * GetClassTemplate ();
    void    Free ();
    Name    Print ();

    friend Word CreateClass (ClassTmpl * ct);
    friend void DeleteClass (Word x);
    friend void PrintClass (Word x);
    friend int CompareClass (Word x, Word y);
    friend Name ClassPrintImage (Word x);
};

inline ClassTmpl *
ClassObject::GetClassTemplate ()
{
    return classtmpl;
}

#define ClassObject_ptr(x)	((ClassObject*)Pointer(x))
#define IsClassObject(x)	IsBuiltinType(x,CLASS_OBJ)

// Foreign Object ////////////////////////////////////////////////

class ForeignObject : public Header {
 private:
    int	   *address;
    const char *object_name;


 public:
    void    Initialize (int *a, const char *n);
    int	   *Address () const {
	return address;
    }
    void    Address (int *a) {
	address = a;
    }
    const char *ObjectName () const {
	return object_name;
    }
    void    ObjectName (const char *n) {
	object_name = n;
    }
    void    Free ();
    Name    Print ();
};

#define ForeignObject_ptr(x)	((ForeignObject*) Pointer (x))
#define IsForeignObject(x)	IsBuiltinType (x,FOREIGN_OBJ)

extern Word CreateForeignObject (int*, const char*);
extern int CompareForeign (Word x, Word y);

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif				/* !aum_builtin_h */
