/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_aumtype_h
#define aum_aumtype_h

// {}
// AU'm ܷ
// {}
typedef enum _AUm_Type {
    AUm_Fixnum	= 0x0,				 /* xxxxxx00 */
    AUm_Atom	= 0x1,				 /* xxxxxx01 */
    AUm_Object	= 0x2,				 /* xxxxxx10 */
    AUm_Constant= 0x3,				 /* xxxxxx11 */
    AUm_SFloat	= 0x3,				 /* xxxxx011 */
    AUm_Bool	= 0x7,				 /* xxxx0111 */
    AUm_True	= AUm_Bool,			 /* xxx00111 */
    AUm_False	= AUm_Bool + (0x1 << 4),	 /* xxx10111 */
    AUm_SObject		  = 0xf,		 /* xxxx1111 */
    AUm_Sink		  = AUm_SObject,	 /* 00001111:SystemObject(0) */
    AUm_UndefOutlet	  = AUm_SObject+(1<<4),	 /* 00011111:SystemObject(1) */
    AUm_UndefInlet	  = AUm_SObject+(2<<4),	 /* 00101111:SystemObject(2) */
    AUm_ErrorObject	  = AUm_SObject+(3<<4),	 /* 00111111:SystemObject(3) */
    AUm_Encoded_DFLOAT	  = AUm_SObject+(8<<4),	 /* 10001111:SystemObject(4) */
    AUm_Encoded_ASCII_STR = AUm_SObject+(9<<4),	 /* 10011111:SystemObject(5) */
    AUm_Encoded_EUC_STR	  = AUm_SObject+(0xa<<4),/* 10101111:SystemObject(6) */
} AUm_Type;

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_aumtype_h */
