/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_allocstats_h
#define aum_allocstats_h

#define ALLOC_STATS

#ifdef ALLOC_STATS

class AllocStatsClass {
private:
    unsigned int n_mj_allocs;
    unsigned int n_mj_frees;
    unsigned int n_aj_allocs;
    unsigned int n_aj_frees;

    unsigned int n_object_allocs;
    unsigned int n_object_frees;

public:
    void	mj_alloc ()	{ n_mj_allocs++; }
    void	mj_free ()	{ n_mj_frees++;	 }
    void	aj_alloc ()	{ n_aj_allocs++; }
    void	aj_free ()	{ n_aj_frees++;	 }
    void	object_alloc () { n_object_allocs++; }
    void	object_free ()	{ n_object_frees++;  }
    void	Report (int on_or_off_flag);
};

extern AllocStatsClass AllocStats;

#define UPDATE_ALLOC_STATS(ARGS)	{ AllocStats.ARGS(); }

#else /* not ALLOC_STATS */

#define UPDATE_ALLOC_STATS(ARGS)

#endif /* not ALLOC_STATS */

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-continued-brace-offset:0
 * c-brace-offset:0
 * c-brace-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-empty-arglist-indent:4
 * c++-friend-offset:0
 * c-imaginary-offset:0
 * c++-electric-colon:t
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */

#endif	/* !aum_allocstats_h */
