/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_allocmsg_h
#define aum_allocmsg_h

#include "aum/alloc.h"

#define CACHED_ALLOC_MESSAGE 1

#ifdef CACHED_ALLOC_MESSAGE

extern void* mg_alloc(unsigned);
extern void  mg_free(void*, unsigned);

#define MESSAGE_ALLOC(n)	mg_alloc(n)
#define MESSAGE_FREE(a,n)	mg_free(a,n)

#else /* not CACHED_ALLOC_MESSAGE */

#define MESSAGE_ALLOC(n)	SHARED_ALLOC(n)
#define MESSAGE_FREE(a,n)	SHARED_FREE(a,n)

#endif /* not CACHED_ALLOC_MESSAGE */

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-continued-brace-offset:0
 * c-brace-offset:0
 * c-brace-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-empty-arglist-indent:4
 * c++-friend-offset:0
 * c-imaginary-offset:0
 * c++-electric-colon:t
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_allocmsg_h */
