/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_alloc_h
#define aum_alloc_h

#ifdef sequent
extern void* shared_alloc(unsigned nbytes);
extern void  shared_free(void* addr, unsigned nbytes);
extern void* private_alloc(unsigned nbytes);
extern void  private_free(void* addr, unsigned nbytes);

#define SHARED_ALLOC(n)		shared_alloc(n)
#define SHARED_FREE(a,n)	shared_free(a,n)
#define PRIVATE_ALLOC(n)	private_alloc(n)
#define PRIVATE_FREE(a,n)	private_free(a,n)

#define ALLOC(n)		shared_alloc(n);
#define FREE(a,n)		shared_free(a,n);

#else /* not sequent */

extern void* pas_alloc (unsigned nbytes);
extern void  pas_free (void* addr, unsigned nbytes);

#define SHARED_ALLOC(n)		pas_alloc(n)
#define SHARED_FREE(a,n)	pas_free(a,n)
#define PRIVATE_ALLOC(n)	pas_alloc(n)
#define PRIVATE_FREE(a,n)	pas_free(a,n)

#define ALLOC(n)		pas_alloc(n);
#define FREE(a,n)		pas_free(a,n);

#endif /* not sequent */

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-continued-brace-offset:0
 * c-brace-offset:0
 * c-brace-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-empty-arglist-indent:4
 * c++-friend-offset:0
 * c-imaginary-offset:0
 * c++-electric-colon:t
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_alloc_h */
