/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_aj_nc_h
#define aum_aj_nc_h

#include "aum/j-nc.h"
#include "aum/j-c.h"


// ///////////////////////////////////////////////////////////////
// {}
// Appender Joint Not Connected type
// {}
class AJ_NC_t : public J_NC_t {
private:
protected:
    J_NC_t*	next_joint;

public:
    void	Initialize (int RC, J_NC_t* joint);
    void	Send (MJ_IMP_OBJ_t*);
    void	Send (MJ_IMP_OBJ_NT_t*);
    J_NC_t*	Next_joint () const;
    void	Next_joint (J_NC_t*);
    AJ_NC_t*	Next_ajoint () const;
    MJ_NC_t*	Next_mjoint () const;
    //
    AJ_C_t*	mut2_AJ_C(Word);
    //
    void	Join (J_NC_t* head);
    void	Connect (J_NC_t*);
    void	Free();
    //
    Name	Print();
    Name	Printname();

};

inline void AJ_NC_t::Initialize (int RC, J_NC_t* joint)
{
    J_NC_t::Initialize (AJ_NC, RC);
    next_joint = joint;
}

inline J_NC_t* AJ_NC_t::Next_joint ()
    const
{
    return next_joint;
}

inline void AJ_NC_t::Next_joint (J_NC_t* joint)
{
    next_joint = joint;
}

inline AJ_NC_t* AJ_NC_t::Next_ajoint ()
    const
{
    return (AJ_NC_t*) next_joint;
}

inline MJ_NC_t* AJ_NC_t::Next_mjoint ()
    const
{
    return (MJ_NC_t*) next_joint;
}

inline AJ_C_t* AJ_NC_t::mut2_AJ_C(Word dest)
{
    ((J_C_t*)this)->Initialize(AJ_C, dest);
    return (AJ_C_t*)this;
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_aj_nc_h */
