/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef aum_aj_c_h
#define aum_aj_c_h

#include "aum/j-c.h"

// ///////////////////////////////////////////////////////////////
// {}
// Appender Joint Connected type
// {}
class AJ_C_t : public J_C_t {
protected:
    J_NC_t*	next_joint;

public:
    Word&	Destination ();
    Word	Dereference ();
    void	Forward (J_NC_t*);
    void	Connect (J_NC_t*);
    J_NC_t*	Next_joint () const;
    void	Next_joint (J_NC_t*);
    AJ_NC_t*	Next_ajoint () const;
    MJ_NC_t*	Next_mjoint () const;

    Name	Print ();
    void	Free ();
};

inline Word& AJ_C_t::Destination ()
{
    return destination;
}

inline J_NC_t* AJ_C_t::Next_joint ()
    const
{
    return next_joint;
}

inline void AJ_C_t::Next_joint (J_NC_t* joint)
{
    next_joint = joint;
}

inline AJ_NC_t* AJ_C_t::Next_ajoint ()
    const
{
    return (AJ_NC_t*) next_joint;
}

inline MJ_NC_t* AJ_C_t::Next_mjoint ()
    const
{
    return (MJ_NC_t*) next_joint;
}

#define Is_AJ_C(x) ((Type_of(x)==AUm_Object) && Pointer(x)->oTag() == AJ_C)

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !aum_aj_c_h */
