#!/bin/sh
# Makefile.sh: A shell script to make Makefiles in subdirectories.
# Location: $(TOP)/pas
# Executed-By: $(TOP)/Configure

config_sh="../config.sh"
Makefile="Makefile"
Makefile_in="Makefile.in"
subdirs=". AUmProgs loader"
config_defs="config.defs"

if test ! -f $config_sh ; then
	echo "Can't find $config_sh"; exit 1
fi
. $config_sh

cat <<EOT >$config_defs
machine=${machine}
bindir=${bindir}
libdir=${libdir}
execdir=${execdir}
yacc=${yacc}
plusplus=${plusplus}
dynamic_link=${dynamic_link}
debug_options=${debug_options}
dldlib=${dldlib}
mbox=${mbox}
socket_comm=${socket_comm}
EOT

for d in ${subdirs} $machine debugger/$machine; do
    mf="${d}/${Makefile}"
    mi="${d}/${Makefile_in}"
    echo 'making '${mf}' from "'${config_defs}'" and "'${mi}'"'
    if [ -w ${mf} ]; then
	  rm -f ${mf}
    fi
    cat - ${config_defs} ${mi} > ${mf} << END_OF_INPUT
END_OF_INPUT
done
