#!/bin/sh
# pas.sh: a script to make "pas".
# Location: $(TOP)/bin
# Executed-By: $(TOP)/Makefile

config_sh="../config.sh"

if test ! -f "$config_sh" ; then
	echo "Can't find config.sh."; exit 1
fi
. $config_sh

cat <<EOSH >pas
#!/bin/sh
#
#	pas
#
#set -x
#
BINDIR="$libdir/exec"
LIBDIR="$libdir"
#
PAS="\${BINDIR}/pas-engine"
PASDB="\${BINDIR}/pas-db-engine"
COMMAND=\${PAS}
OPTIONS="system.aas debugio.aas derive.aao wait.aao"
#
#
case \$# in
0)
	\${COMMAND};
	exit 1;;
*)
	;;
esac

for i
do case \$i in
-d*)
	COMMAND=\${PASDB};
	shift; continue;
	;;
*)
	OPTIONS="\$OPTIONS \$i";
	;;
esac
done

exec \${COMMAND} \${OPTIONS}
EOSH
