# Makefile.sh: a script to make a makefile
# Location: $(TOP)/bin
# Executed-by: $(TOP)/Configure

config_sh="../config.sh"

if test ! -f $config_sh; then
	echo "Can't find $config_sh"; exit 1
fi
. $config_sh

echo "making Makefile..."

cat > Makefile <<EOT
# Makefile: a makefile
# Location: $(TOP)/bin
# Executed-by: $(TOP)/Makefile

BINDIR=${bindir}

all			: pas

pas			: pas.sh
	sh pas.sh

install		:
	install -c pas $(BINDIR)

clean		:
	rm -f pas *~
EOT
