/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNxor_h
#define SNxor_h 1

#include "SNbinop.h"
#include "CDxor.h"

struct SNxor : SNbinop {
  SNxor(SNunit* a1, SNunit* a2) : SNbinop("xor", a1, a2) {}
  char* opName() { return "xor"; }

  void encodeMessageSending(Rind r1, Rind r2, Rind r3, instList& code) {
    code.add(new CDxor(r1, r2, r3));
  }
};

#endif SNxor_h
