/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNwho_h
#define SNwho_h 1

#include "SNunit.h"

class instList;

class SNwho : public SNunit {
  SNunit* who;
public:
  SNwho(SNunit* w) : SNunit("who") { who = w; }
  void print(ostream& ost) { who->print(ost); ost << " ?"; }
  void split(int) { who->split(1); }
  int inletExp() { return 1; }
  Rind encode(instList&);	      // Send `who_are_you/+.'
  void encodeAtGround(instList&);     // Connect to $sink.
  Rind connected(SNunit*, instList&); // Error !
  Rind connectTo(Rind, instList&);    // Proper usage.
  Rind connectToVolatile(instList& code, char* l) { return encode(code); }

  SNunit* getWho() { return who; } // ۵aumc-parse.yǻȤäƤ롣
};

#endif SNwho_h
