/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include <assert.h>
#include <stream.h>
#include <stdlib.h>
#include "RegTable.h"
#include "SNwho.h"
#include "inst.h"
#include "CDconnect.h"
#include "CDcsink.h"
#include "CDwho.h"

// `Y = X ?' is equivalent to `X :who_are_you(Y).'

Rind SNwho::encode(instList& code)
{
  Rind Rdest = who->encode(code);   // encode `X.'
  Rind Rwho = regTable.newReg();    // make `Y.'
  regTable.set(Rwho);		    //
  code.add(new CDwho(Rdest, Rwho)); // send `who_are_you/+.'
  regTable.decrement(Rdest);	    // close `X.'
  return Rwho;			    // return `Y.'
}

void SNwho::encodeAtGround(instList& code)
{
  Rind r = encode(code);
  Rind Rsink = regTable.newReg();
  code.add(new CDcreate_sink(Rsink));
  code.add(new CDconnect(Rsink, r));
				// These two instructions should be
				// replaced by a 'connect_to_sink.'
  regTable.decrement(r);
}

Rind SNwho::connected(SNunit* inlet, instList& code)
{
  assert(FALSE);
  // not reached; the following line is a dummy.
  return -1;
}

Rind SNwho::connectTo(Rind outlet, instList& code)
{
  Rind inlet = encode(code);
  code.add(new CDconnect(outlet, inlet));
//  regTable.decrement(inlet);	// inlet ¦иȤ򸺤餹
  autoClose(inlet, code);
//  SNinlet.cSNinlet::connectTo() 򻲾Ȥ衣
//  regTable.decrement(outlet); // outlet ¦иȤ򸺤餹
//  regTable.connected(outlet); // outlet ¦closeFlag򲼤
  return outlet;
}
