/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNvolatile_h
#define SNvolatile_h 1

#include "SNunit.h"
#include "SNclass.h"
#include "SNunitArray.h"
#include "Rind.h"
#include "OnOff.h"

class intMHList;
class inst;
class instList;
class MovTable;
class SNname;
class SNexport;
class SNcond;
class Name;
class NameList;
class ProtocolList;

class SNvolatile : public SNclass, virtual public SNunit {
friend class SNtree;

  virtual void encodeAtGround(instList& code) { encodeAtGround(code, 0); }
  virtual void encodeAtGround(instList&, inst* = 0);

private:
  SNunit* interface;
  SNexport* exports;
  MovTable* movTablep;
  instList* syncCode;

  SNname label(char*);
  SNname reentryLabel();
  SNname resumeLabel();
  SNname exitLabel();

  void encodeCreateSync(Rind, Rind, instList&, char*);
  Rind encodeCreateMjoint(instList&);
  void encodeSuspension(instList&);
  Rind encodeCreation(Rind, instList&, char*);
  ProtocolList collectProtocols();
  void encodeDirectBranch(Rind, instList&);
  void encodeInletIF(instList&);
  void encodeSyncObject(instList&);
  void encodeOutletIF(instList&);
  void encodeInterface(instList&);
  void encodeAllMethods(instList&, inst*);
  void encodeAsClass(instList&, inst*);

public:
  SNvolatile(SNunit*);
  ~SNvolatile();
  void print(ostream& ost);
  int isVolatile() { return 1; }
  void export(SNexport* snvars) { exports = snvars; }
  void split(int);
  void setName(intMHList, char*);
  void printProtocols();
  int maxSelectorLength();
  void printSelectorLengths();
  void checkSelectorLengths();

  void printSyncCode(ostream& ost);
};

#endif SNvolatile_h
