/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include <assert.h>
#include <stream.h>
#include "intMHList.h"
#include "intList.h"
#include "Name.h"
#include "RegTable.h"
#include "SNcond.h"
#include "SNerror.h"
#include "SNexport.h"
#include "SNliteral.h"
#include "SNmethod.h"
#include "SNtcs.h"
#include "SNtree.h"
#include "SNvolatile.h"
#include "nameStream.h"
#include "Protocol.h"
#include "PcolList.h"
#include "Classref.h"
#include "MovTable.h"
#include "CDactivate.h"
#include "CDbow.h"
#include "CDcvol2.h"
#include "CDgetinlet.h"
#include "CDgetoutlet.h"
#include "CDsend_self.h"
#include "CDif_true.h"
#include "CDcmj.h"
#include "CDconnect.h"
#include "CDjump.h"
#include "CDlabel.h"
#include "CDmove.h"
#include "CDterminate.h"
#include "CDwait.h"
#include "CDwho.h"
#include "OnOff.h"
#include "PIcomment.h"
#include "PIend.h"
#include "PIentry.h"
#include "PIvol.h"
#include "errmsg.h"

class instList;

SNvolatile::SNvolatile(SNunit* infc)
: SNunit("volatile"), SNclass(new SNname("")), interface(infc),
movTablep(0), syncCode(0) {}

SNvolatile::~SNvolatile()
{
  delete interface;
  delete exports;
  delete movTablep;
  delete syncCode;
}

void SNvolatile::print(ostream& ost)
{
  interface->print(ost); ost << " ? " << "(\n";
  printNames("super", &supers, ost);
  printNames("in", &islots, ost);
  printNames("out", &oslots, ost);
  printMethods(&methods, ost, ";");
  ost << "\n)";
}

void SNvolatile::split(int n)
{
  if (interface->inletExp()) {
    interface->split(0);
  }
  else {			// interface is outlet
    interface->split(1);
  }
  exports->split();
  SNclass::split();
}

void SNvolatile::setName(intMHList path, char* classname)
{
#ifdef IOSTREAM_2_0
  ostrstream nameStream(namebuffer, bufsize);
#else
  ostream nameStream(bufsize, namebuffer);
#endif
  intMHListItr numbers(path);
  for (int i = numbers() ; i != 0 ; i = numbers.next()) {
    nameStream << "v" << i;
    i = numbers.next();
    assert(i != 0);
    nameStream << "m" << i;
  }
  nameStream << classname;
  nameStream.put('\0');
  name = new SNname(namebuffer, EMescaped);
}

void SNvolatile::printProtocols()
{
  gList_iterator(SNmethod) mtds(&methods);
  for (SNmethod* mp = mtds() ; mp ; mp = mtds.next()) {
    cout << "'" << *name << "/";
    mp->printProtocol();
    cout << "'\n";
  }
}

int SNvolatile::maxSelectorLength()
{
  gList_iterator(SNmethod) mtds(&methods);
  int max = 0;
  for (SNmethod* mp = mtds() ; mp ; mp = mtds.next()) {
    int len = mp->selectorLength();
    if (len > max) max = len;
  }
  return max;
}

void SNvolatile::printSelectorLengths()
{
  cout << "class : " << *name << "\n";
  gList_iterator(SNmethod) mtds(&methods);
  for (SNmethod* mp = mtds() ; mp ; mp = mtds.next()) {
    cout << mp->selector() << " : " << mp->selectorLength() << "\n";
  }
  cout << form("max : %d\n", maxSelectorLength());
}

void SNvolatile::checkSelectorLengths()
{
  gList_iterator(SNmethod) mtds(&methods);
  for (SNmethod* mp = mtds() ; mp ; mp = mtds.next()) {
    if (mp->selectorLength() > 0) {
      SNerror("sorry, methods with arguments in volatile classes "
	      "are not supported",
	      mp->LineNumber());
    }
  }
}

void SNvolatile::encodeCreateSync(Rind Rif,
				  Rind Rres,
				  instList& code,
				  char* classname = 0)
{
  if (classname == 0) classname = *name;

  // ܥ饿륯饹̾򻲾ȥ饹ɽϿ롣
  Classref::intern(classname);

  // ܥ饿륯饹󥿡եȤĤʤɤФ
  Rind Rv = regTable.newReg();
  code.add(new CDcreate_volatile(Rv, Rres, classname));
  code.add(new CDconnect(Rv, Rif));
  regTable.decrement(Rif);
}

Rind SNvolatile::encodeCreateMjoint(instList& code)
{
  Rind Rres = regTable.newReg();
  regTable.set(Rres, 1);
  code.add(new CDcreate_mjoint(Rres));
  return Rres;
}

SNname SNvolatile::label(char* s)
{
#ifdef IOSTREAM_2_0
  ostrstream nameStream(namebuffer, bufsize);
#else
  ostream nameStream(bufsize, namebuffer);
#endif
  nameStream << s << name->trueName();
  nameStream.put('\0');
  return SNname(namebuffer);
}

SNname SNvolatile::reentryLabel()
{
  return label("enter_");
}

void SNvolatile::encodeSuspension(instList& code)
{
  // ³å˥ɤ٤쥸롣
  movTablep = new MovTable(regTable);
  int maxSelLen = maxSelectorLength();
  movTablep->fold(maxSelLen);
  intList* argRinds = movTablep->argList();

  // ³å륳ɤФ
  SNname reentry = reentryLabel();
  Protocol* ipp = Protocol::intern(reentry, argRinds->length());
  Name reentryname = ipp->string();
  code.add(new CDsend_self(reentryname, argRinds));

  // ڥɤΥɤФ
  code.add(new CDwait());

  // ³᥽åɤΥ٥Ϥ롣
  ipp->addPImethod(code);
  code.add(new CDlabel(reentryname));

  // 쥸륳ɤФ
  movTablep->encodeUnfolding(code);
}


Rind SNvolatile::encodeCreation(Rind Rif,
				instList& code,
				char* classname = 0)
{
  // å֥ȼѤΥȥ꡼륳ɤϤ롣
  Rind Rres = encodeCreateMjoint(code);

  // ܥ饿륯饹󥿡եȤĤʤɤФ
  encodeCreateSync(Rif, Rres, code, classname);

  // ڥɤȥ쥸ΥɤϤ롣
  encodeSuspension(code);

  return Rres;
}

ProtocolList SNvolatile::collectProtocols()
{
  ProtocolList pcols;
  SNmethodListItr mit(get_methods());
  for (SNmethod* mp = mit() ; mp ; mp = mit.next()) {
    pcols.add(mp->selector());
  }
  return pcols;
}

void SNvolatile::encodeDirectBranch(Rind Rwho, instList& code)
{
  // branch_on_who ̿Ф
  code.add(new CDbranch_on_who(Rwho, get_methods().length()));

  // ƥ᥽åɤؤ entry ̿Ф
  SNmethodListItr methodIt(get_methods());
  for (SNmethod* methodp = methodIt() ; methodp ;
       methodp = methodIt.next()) {
    Protocol* pcol = methodp->selector();
    Name aBranch = pcol->label(*name);
    Name entryname = pcol->funcname();
    code.add(new PIentry(entryname, aBranch));
  }
}

SNname SNvolatile::resumeLabel()
{
  return label("resume_");
}

void SNvolatile::encodeSyncObject(instList& code)
{
  code.add(new PIcomment(""));

  // ܥ饿̿Ф
  code.add(new PIvolatile(*name));

  // ̥ɤΥȥ꡼٥롣
  SNname resume = resumeLabel();

  SNmethodListItr mit(get_methods());
  for (SNmethod* mp = mit() ; mp ; mp = mit.next()) {
    // ᥽å̿ȥȥ꡼٥Ф
    mp->putPseudoInst(code);
    mp->putEntranceLabel(0, code);

    // 쥯бå֥Ȥ륳ɤФ
    gList_iterator(SNunit) ait(&(mp->get_actions()));
    SNmessage* mp = (SNmessage*)ait();
    SNunit* func = mp->functor();
    assert(func->isLiteral());
    ((SNliteral*)func)->encodeCreation(0, code);

    // ̥ɤJump륳ɤФ
    code.add(new CDjump(resume));
  }

  // ̥ɥȥ꡼٥Ф
  code.add(new CDlabel(resume));

  // å֥Ȥ̥ȥ꡼ˤĤʤɤФ
  code.add(new CDget_inlet(1, "result"));
  code.add(new CDconnect(0, 1));

  // Τư륳ɤФ
  code.add(new CDget_outlet(0, "creator"));
  code.add(new CDactivate(0));

  // ޤ
  code.add(new CDterminate());
  code.add(new PIend(*name));
}

void SNvolatile::encodeInletIF(instList& code)
{
  // interface ɾ륳ɤФ
  Rind Rif = interface->encode(code);

  // Ʊѥ֥ȤڥɡӺƵưΥɤФ
  Rind Rres = encodeCreation(Rif, code);

  // ľʬɤФ
  encodeDirectBranch(Rres, code);

  // Rres 롣
  regTable.decrement(Rres);

  // Ʊѥ֥ȤΥɤ롣
  syncCode = new instList;
  encodeSyncObject(*syncCode);
}

void SNvolatile::encodeOutletIF(instList& code)
{
  // ޤƥ᥽åɤΥ쥯Υץȥ򽸤롣
  ProtocolList pcols = collectProtocols();
  assert(maxSelectorLength() == 0); // ¾Ĵ٤Ƥ롣

  // 1) 쥯 `true  `false Ǥäơ
  //	if_XX ̿᤬Ȥ륤󥿡եǤ롣
  if (pcols.length() == 2
      && pcols.member(SNcond::trueProtocol)
      && pcols.member(SNcond::falseProtocol)
      && interface->isCondExp()) {

    // `true ٥ `false ٥롣
    Name trueLabel = SNcond::trueProtocol->label(*name);
    Name falseLabel = SNcond::falseProtocol->label(*name);

    // if_XX ̿Ф
    Rind Rif = ((SNcond*)interface)->encodeAsInterface(trueLabel,
						  falseLabel, code);

    // who ̿Ф
    Rind Rwho = regTable.newReg();
    regTable.set(Rwho);
    code.add(new CDwho(Rif, Rwho));
    regTable.decrement(Rif);

    // Ʊѥ֥ȤڥɡӺƵưΥɤФ
    Rind Rres = encodeCreation(Rwho, code, "if_then_else");

    // if_true ̿Ф
    code.add(new CDif_true(Rres, trueLabel, falseLabel));
    regTable.decrement(Rres);
  }
  // 2) ʳξ
  else {
    // interface ɾ륳ɤФ
    Rind Rif = interface->encode(code);

    // ľʬΥɤФ
    encodeDirectBranch(Rif, code);

    // who ̿Ф
    Rind Rwho = regTable.newReg();
    regTable.set(Rwho);
    code.add(new CDwho(Rif, Rwho));
    regTable.decrement(Rif);

    // å֥ȼѤΥȥ꡼interface Υ쥸֤
    Rind Rmobj = regTable.newReg();
    regTable.set(Rmobj, 1);
    code.add(new CDcreate_mjoint(Rmobj));

    // ܥ饿륯饹who ͤȤĤʤɤФ
    encodeCreateSync(Rwho, Rmobj, code);

    // ڥɤȥ쥸ΥɤϤ롣
    encodeSuspension(code);

    // ľʬΥɤФ
    encodeDirectBranch(Rmobj, code);
    regTable.decrement(Rmobj);

    // Ʊѥ֥ȤΥɤ롣
    syncCode = new instList;
    encodeSyncObject(*syncCode);
  }
}

void SNvolatile::encodeInterface(instList& code)
{
  if (interface->inletExp()) {
    encodeInletIF(code);
  }
  else {			// interface is outlet
    encodeOutletIF(code);
  }
}

SNname SNvolatile::exitLabel()
{
  return label("exit_");
}

void SNvolatile::encodeAllMethods(instList& code, inst* descentInst)
{
  gList_iterator(SNmethod) mtds(&methods);
  for (SNmethod* mp = mtds() ; mp ; mp = mtds.next()) {
    mp->putEntranceLabel(*name, code);
    exports->saveRegs();
    mp->encode(exports, descentInst, code);
    exports->restoreRegs();
  }
}

void SNvolatile::encodeAsClass(instList& code, inst* descentInst)
{
  SNtree::currentClass = this;
  if (descentInst) {
    encodeAllMethods(code, descentInst);
  }
  else {
    SNname exit = exitLabel();
    Protocol* ipp = Protocol::intern(exit, 0);

    encodeAllMethods(code, new CDjump(exit));

    code.add(new CDlabel(exit));
  }
}

void SNvolatile::encodeAtGround(instList& code, inst* descentInst)
{
  exports->assignRegno(code);
  encodeInterface(code);
  treeContextStack.save(SNtree::currentClass,
			SNtree::currentMethod);
  encodeAsClass(code, descentInst);
  treeContextStack.restore(SNtree::currentClass,
			   SNtree::currentMethod);
  exports->autoClose(code);
}

void SNvolatile::printSyncCode(ostream& ost)
{
  if (syncCode) syncCode->print(ost);
}
