/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include "SNvector.h"
#include "RegTable.h"
#include "CDcvector.h"
#include "CDcint.h"
#include "CDsplit_n.h"

Rind SNvector::encode(instList& code)
{
  Rind Rvec = regTable.newReg();
  regTable.set(Rvec, 1, OnOff(splitCount < 1));
  Rind Rlen = len->encode(code);
  code.add(new CDcreate_vector(Rvec, Rlen));
  regTable.decrement(Rlen);
  if (splitCount > 1) {
    code.add(new CDsplit_n(Rvec, splitCount - 1));
  }
  return Rvec;
}
