/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNunop_h
#define SNunop_h 1

#include "SNunit.h"
#include "SNunarg.h"

class SNunop : public SNunit, public SNunarg {
  // from SNunit
  virtual void print(ostream& ost) { SNunarg::print(ost); }
  virtual void split(int n) { SNunarg::split(n); }
  virtual Rind encode(instList& code) { return SNunarg::encode(code); }
  // from SNunarg
  virtual char* _opName() { return opName(); }
  virtual void _encodeMessageSending(Rind r1, Rind r, instList& code) {
    encodeMessageSending(r1, r, code);
  }
  // its own
  virtual char* opName() = 0;
  virtual void encodeMessageSending(Rind, Rind, instList&) = 0;

public:
  SNunop(char* nm, SNunit* a) : SNunit(nm), SNunarg(a) {}
};

#endif SNunop_h
