/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNunit_h
#define SNunit_h 1

#include <stream.h>
#include <string.h>
#include "freshString.h"
#include "Rind.h"

class inst;
class instList;
class NameList;
class SNvolatile;

// class SNunit : an abstract class for any particular type of nodes
// and leaves in SyNtactic trees.

class SNunit {
protected:
  char* classname;    // debugging information
  int lineNumber;

  void claimClass();

public:
  SNunit(char* n) : classname(n), lineNumber(0) {}
  virtual void print(ostream&) = 0;
  virtual int isVolatile() { return 0; }
  virtual int inletExp() { return 0; }
  virtual int isCondExp() { return 0; }
  virtual int isLiteral() { return 0; }
  virtual void split(int) = 0;

  void LineNumber(int ln) { lineNumber = ln; }
  int LineNumber() { return lineNumber; }

  //
  // Methods for encoding
  //
  virtual Rind encode(instList&);
				// ߡƤӽФ줿ϥ顼
  virtual void encodeAtGround(instList&);
				// ͤ outlet ξ硣
				// 롣
  virtual void encodeAtGround(instList&, inst*);
				// ܥ饿Ǥʤ硣
  virtual void encodeAsSelectorArg(Rind, instList&);
				// 쥯ΰ outlet ǡ
				// ѿǤʤ
  virtual Rind encodeDestination(instList& code) {
    return encode(code);	// 褬ѿǤʤ硣
  }
  virtual Rind connected(SNunit* inlet, instList& code) {
    return inlet->connectTo(encode(code), code);
  }				// ͥȤκդ outlet ξ硣
  virtual Rind connectTo(Rind, instList&);
				// ͥȤαդ outlet ξ硣
				// 顼
  virtual void connectedAtGround(SNunit*, instList&);
				// ͥȤκդ inlet slot Ǥʤ硣

  Rind encodeWho(Rind, instList&);

  // 
  virtual Rind regno();		// ѿʳμǤϥ顼򵯤
};

inline ostream& operator<<(ostream& ost, SNunit* u)
{
  u->print(ost); return ost;
};

// Since the operator new requires user-defined type to its argument,
// following pointer type have to be defined in order to allocate
// vectors of pointers to SNunits.
typedef SNunit* SNunitptr;

void autoClose(Rind, instList&);

inline void SNunit::connectedAtGround(SNunit* inlet, instList& code)
{
  autoClose(connected(inlet, code), code);
}

#endif SNunit_h
