/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include <stream.h>
#include <stdlib.h>
#include "SNunit.h"
#include "SNvolatile.h"
#include "Rind.h"
#include "inst.h"
#include "CDconnect.h"
#include "CDclose.h"
#include "CDwho.h"
#include "RegTable.h"

void SNunit::claimClass()
{
  cerr << "for an object of class " << classname << ".\n";
}

void SNunit::encodeAtGround(instList& code)
{
  autoClose(encode(code), code);
}

Rind SNunit::encode(instList& code)
{
  cerr << "system error : virtual function SNunit::encode() called.\n";
  claimClass();
  exit(1);
  // not reached; the following line is a dummy.
  return -1;
}

void SNunit::encodeAtGround(instList& code, inst* descendInst)
{
  encodeAtGround(code);
  code.add(descendInst);
}

void SNunit::encodeAsSelectorArg(Rind pos, instList& code)
{
  Rind r = encode(code);	// 쥯ΰ outlet ǡ
  code.add(new CDconnect(r, pos)); // ѿǤʤ硣Ĥޤꡢ
  // :foo(3) ʤ :foo(A) -> 3 = ^A ξ硣
  // A ϥ쥸˼ư֤°
  // 3 ϥ᥽åǺ͡
  // AˤĤƤϡиȤϸ餹٤close ס
  // äơ
  regTable.decrement(pos);
  // 
  // 3 ⡢A ήߤɬ뤫顢close ס
  // иȤϸ餵ʤȥ쥸ʤɬס
  // äơ
  regTable.decrement(r);
  // 
}

Rind SNunit::connectTo(Rind outlet, instList& code)
{
  cerr << "system error : virtual function SNunit::connectTo() called.\n";
  claimClass();
  exit(1);
  // not reached; the following line is a dummy.
  return -1;
}

Rind SNunit::encodeWho(Rind r, instList& code)
{
  Rind Rwho = regTable.newReg();    // make `Y.'
  regTable.set(Rwho);		    //
  code.add(new CDwho(r, Rwho));	    // send `who_are_you/+.'
  regTable.decrement(r);	    // close `X.'
  return Rwho;			    // return `Y.'
}

// Currently, autoClose() is not a member funcion of any class.
// It should be a member of a class that represents container such as
// messsages, vectors, and lists.

void autoClose(Rind r, instList& code)
{
  regTable.decrement(r);
  if (regTable.needClose(r)) {
    code.add(new CDclose(r));
  }
}

Rind SNunit::regno()
{
  cerr << "system error : virtual funciton SNunit::regno() called.\n";
  claimClass();
  exit(1);
  // not reached; the following line is a dummy.
  return -1;
}
