/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNuncond_h
#define SNuncond_h 1

#include "SNunarg.h"
#include "SNcond.h"
#include "Protocol.h"

class NameList;
class SNvolatile;

class SNuncond : public SNcond, public SNunarg {
  // from SNunit inherited by SNcond
  virtual void print(ostream& ost) { SNunarg::print(ost); }
  virtual void split(int n) { SNunarg::split(n); }
  virtual Rind encode(instList& code) { return SNunarg::encode(code); }
  // from SNunarg
  virtual char* _opName() { return opName(); }
  virtual void _encodeMessageSending(Rind r1, Rind r, instList& code) {
    encodeMessageSending(r1, r, code);
  }
  // its own
  virtual Rind encodeAsInterface(char*, char*, instList&);
  virtual char* opName() = 0;
  virtual void encodeMessageSending(Rind, Rind, instList&) = 0;
  virtual void addDirectJump(Rind, char*, char*, instList&) = 0;

public:
  SNuncond(char* nm, SNunit* arg) : SNcond(nm), SNunarg(arg) {}
};

#endif SNuncond_h
