/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNunarg_h
#define SNunarg_h 1

#include "SNunit.h"

class SNunarg {
protected:
  SNunit* arg;
  int splitCount;

  Rind encodeOperation(Rind, instList&);
  void print(ostream& ost) {
    ost << _opName() << " " << arg;
  }
  void split(int n) { arg->split(1); splitCount = n; }
  Rind encode(instList&);
  virtual char* _opName() = 0;
  virtual void _encodeMessageSending(Rind, Rind, instList&) = 0;

public:
  SNunarg(SNunit* a) : arg(a), splitCount(0) {}
};

#endif SNunarg_h
