/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include "OnOff.h"
#include "RegTable.h"
#include "SNunarg.h"
#include "CDsplit_n.h"
#include "CDclose.h"

Rind SNunarg::encode(instList& code)
{
  Rind r1 = arg->encode(code);
  return encodeOperation(r1, code);
}

Rind SNunarg::encodeOperation(Rind r1, instList& code)
{
  Rind r = regTable.newReg();
  regTable.set(r, 1, OnOff(splitCount < 1));
  _encodeMessageSending(r1, r, code);
  regTable.decrement(r1);
  if (splitCount > 1) {
    code.add(new CDsplit_n(r, splitCount - 1));
  }
  return r;
}
