/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNtree_h
#define SNtree_h 1

#include "List.h"
#include "MHList.h"
#include "SNclass.h"
#include "SNerror.h"
#include "SNmethod.h"
#include "SNmethodList.h"
#include "intMHList.h"

class ostream;
class instList;
class SNtreeContextStack;

class SNtree {
  SNclass* root;

  void nameOneVolatile(SNclass*, intMHList, char*);
  void printOneProtocol(SNclass*);
  void printOneSelectorLength(SNclass*);
  void checkOneSelectorLength(SNclass*);
  void bindInletAndTopOutlet(SNclass*);
  void printOneSyncCode(SNvolatile*, ostream&);

public:
  static SNclass* currentClass;
  static SNmethod* currentMethod;

  SNtree(SNclass* clp) : root(clp) {}
  void nameVolatiles();
  void printProtocols() { printOneProtocol(root); }
  void printSelectorLengths() { printOneSelectorLength(root); }
  void checkSelectorLengths() { checkOneSelectorLength(root); }
  void encodeAndPrint(ostream& ost) { root->encodeAndPrint(ost); }
//  void markSinks() { markSink(root); }
  void bindInletAndTopOutlet() { bindInletAndTopOutlet(root); }
  void printSyncCode(ostream&);
};

extern SNtreeContextStack treeContextStack;

#endif SNtree_h
