/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include "ostream.h"
#include "SNtree.h"
#include "SNvolatile.h"
#include "SNtcs.h"

class instList;

SNtreeContextStack treeContextStack;
SNmethod* SNtree::currentMethod;
SNclass*  SNtree::currentClass;

// void nameOneVolatile(SNclass* current, gList(int) path)
// {
//   for (current Τ٤ƤΥ᥽åmpˤĤ) {
//     mp ֹ path  ץå;
//     for (mp Τ٤ƤΥܥ饿 vp ˤĤ) {
//	 vp ֹ path ˥ץå;
//	 vp ̾Ĥ;
//	 nameVolatile(vp, path);
//	 path ݥå;
//     }
//     path ݥå;
//   }
// }

void SNtree::nameVolatiles() {
  intMHList path;
  Name rootname = *root->name;
  nameOneVolatile(root, path, rootname);
}

void SNtree::nameOneVolatile(SNclass* current, intMHList path, char* rootname)
{
  gList_iterator(SNmethod) methods(&(current->methods));
  int m = 1;
  for (SNmethod* mp = methods() ; mp ; mp = methods.next()) {
    path.push(m++);
    SNvolatileListItr classes(mp->get_volatiles());
    int v = 1;
    for (SNvolatile* vp = classes() ; vp ; vp = classes.next()) {
      path.push(v++);
      vp->setName(path, rootname);
      nameOneVolatile(vp, intMHList(path), rootname);
      path.pop();
    }
    path.pop();
  }
}

void SNtree::printOneProtocol(SNclass* clp)
{
  clp->printProtocols();
  gList_iterator(SNmethod) mtds(&(clp->methods));
  for (SNmethod* mp = mtds() ; mp ; mp = mtds.next()) {
    SNvolatileListItr volts(mp->get_volatiles());
    for (SNvolatile* vp = volts() ; vp ; vp = volts.next()) {
      printOneProtocol(vp);
    }
  }
}

void SNtree::printOneSelectorLength(SNclass* clp)
{
  clp->printSelectorLengths();
  gList_iterator(SNmethod) mtds(&(clp->methods));
  for (SNmethod* mp = mtds() ; mp ; mp = mtds.next()) {
    SNvolatileListItr volts(mp->get_volatiles());
    for (SNvolatile* vp = volts() ; vp ; vp = volts.next()) {
      printOneSelectorLength(vp);
    }
  }
}

void SNtree::checkOneSelectorLength(SNclass* clp)
{
  clp->checkSelectorLengths();
  gList_iterator(SNmethod) mtds(&(clp->methods));
  for (SNmethod* mp = mtds() ; mp ; mp = mtds.next()) {
    SNvolatileListItr volts(mp->get_volatiles());
    for (SNvolatile* vp = volts() ; vp ; vp = volts.next()) {
      checkOneSelectorLength(vp);
    }
  }
}

void SNtree::bindInletAndTopOutlet(SNclass* clp)
{
  gList_iterator(SNmethod) mtds(&clp->methods);
  for (SNmethod* mp = mtds() ; mp ; mp = mtds.next()) {
    gMHList_iterator(SNstream) streamIt(&mp->streams);
    for (SNstream* streamp = streamIt() ; streamp ;
	 streamp = streamIt.next()) {
      streamp->bindInletAndTopOutlet();
    }
  }
  mtds.reset();
  for (mp = mtds() ; mp ; mp = mtds.next()) {
    SNvolatileListItr volts(mp->get_volatiles());
    for (SNvolatile* vp = volts() ; vp ; vp = volts.next()) {
      bindInletAndTopOutlet(vp);
    }
  }
}

void SNtree::printOneSyncCode(SNvolatile* clp, ostream& ost)
{
  clp->printSyncCode(ost);
  gList_iterator(SNmethod) mtds(&(clp->methods));
  for (SNmethod* mp = mtds() ; mp ; mp = mtds.next()) {
    SNvolatileListItr volts(mp->get_volatiles());
    for (SNvolatile* vp = volts() ; vp ; vp = volts.next()) {
      printOneSyncCode(vp, ost);
    }
  }
}

void SNtree::printSyncCode(ostream& ost)
{
  gList_iterator(SNmethod) mtds(&(root->methods));
  for (SNmethod* mp = mtds() ; mp ; mp = mtds.next()) {
    SNvolatileListItr volts(mp->get_volatiles());
    for (SNvolatile* vp = volts() ; vp ; vp = volts.next()) {
      printOneSyncCode(vp, ost);
    }
  }
}
