/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNtcs_h
#define SNtcs_h 1

#include "gList.h"

class SNtreeContext;
class SNclass;
class SNmethod;
class ostream;

declare(gList,SNtreeContext);

struct SNtreeContext {
  SNclass* classp;
  SNmethod* methodp;

  SNtreeContext(SNclass* cp, SNmethod* mp) {
    classp = cp;
    methodp = mp;
  }
  SNclass* thisClass() { return classp; }
  SNmethod* thisMethod() { return methodp; }
};

class SNtreeContextStack : public gList(SNtreeContext) {
public:
  SNtreeContextStack() {};
  void save(SNclass*, SNmethod*);
  void restore(SNclass*&, SNmethod*&);
  void printPathByIndex(ostream&);
};

class SNtreeCSItr : public gList_iterator(SNtreeContext) {
public:
  SNtreeCSItr(SNtreeContextStack& tcs)
    : gList_iterator(SNtreeContext)(&tcs) {}
};

#endif SNtcs_h
