/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include "SNtree.h"
#include "SNtcs.h"
#include "nameStream.h"

void SNtreeContextStack::save(SNclass* cp, SNmethod* mp)
{
  push(new SNtreeContext(cp, mp));
}

void SNtreeContextStack::restore(SNclass*& cp,
				 SNmethod*& mp)
{
  SNtreeContext* pcp = pop();
  cp = pcp->thisClass();
  mp = pcp->thisMethod();
  delete pcp;
}

void SNtreeContextStack::printPathByIndex(ostream& ost)
{
  SNclass* cp = SNtree::currentClass;
  SNmethod* mp = SNtree::currentMethod;
  SNtreeCSItr tcs(treeContextStack);
  SNtreeContext* context = tcs();

  SNmethodListItr methods(cp->get_methods());
  int i = methods.index(mp);
  ost << "m" << i;

  while (context) {
    SNvolatileListItr classes(context->thisMethod()->get_volatiles());
    i = classes.index((SNvolatile*)cp);
    ost << "v" << i;
    cp = context->thisClass();
    mp = context->thisMethod();
    context = tcs.next();
    methods = SNmethodListItr(cp->get_methods());
    int i = methods.index(mp);
    ost << "m" << i;
  }
  ost << cp->get_name().trueName();
}
