/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNsymbol_h
#define SNsymbol_h 1

#include <string.h>
#include "SNliteral.h"
#include "SNname.h"
#include "CDcatom.h"		// Create atom

class SNsymbol : public SNliteral {
  SNname name;

  virtual void encodeCreation(Rind r, instList& code) {
    code.add(new CDcreate_atom(r, name));
  }

public:
  SNsymbol(char* nm, SNnameEscapeMode mode = EMnormal)
    : SNliteral("symbol"), name(nm, mode) {}

  void print(ostream& ost) {
    ost << name;
  }
};

#endif SNsymbol_h
