/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNstring_h
#define SNstring_h 1

#include <string.h>
#include "SNliteral.h"
#include "CDcstring.h"		// Create string

class SNstring : public SNliteral {
  char* name;

  virtual void encodeCreation(Rind r, instList& code) {
    code.add(new CDcreate_string(r, name));
  }

public:
  SNstring(char*);
  ~SNstring();
  void print(ostream&);
};

inline SNstring::SNstring(char* nm) : SNliteral("string")
{
  name = new char[strlen(nm) + 1];
  strcpy(name, nm);
}

inline SNstring::~SNstring()
{
  delete name;
}

inline void SNstring::print(ostream& ost)
{
  ost << "\"" << name << "\"";
}

#endif SNstring_h
