/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include <string.h>
#include "SNstreamList.h"

SNstream* SNstreamList::find(char* key)
{
  gMHList_iterator(SNstream) it(this);
  for (SNstream* s = it() ; s ; s = it.next()) {
    if (strcmp(s->get_name(), key) == 0) return s;
  }
  return 0;
}

SNstream* SNstreamList::findOrMake(char* name)
{
  SNstream* SNsrmp = find(name);
  if (SNsrmp == 0) {
    SNsrmp = new SNstream(name);
    push(SNsrmp);
  }
  return SNsrmp;
}
