/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNstream_h
#define SNstream_h 1

#include <bool.h>
#include "SNunit.h"

#include "gList.h"
#include "OnOff.h"

class instList;
class Name;

enum {ORD_INLET, ORD_OUTLET};

static struct orderCount {
  int order;
  int count;			// number of appearances
  int split;			// number of splitting required
  Rind regno;			// 쥸ֹ
  orderCount(int ord) : order(ord), count(0), split(0), regno(-1) {}
};

static declare(gList, orderCount);

class SNstream : public SNunit {
friend class SNstreamtable;
  char* name;			     // ǥХå
  int n_order;			     // ̤θĿ
  int topOrder;			     // ǹ
  OnOff inletApp;		     // inlet νи̵ͭ
  gList(orderCount) appearances;     // ƽ̤νиȤʤ
  orderCount* findOrMakeOrderCount(int);
  orderCount* find(int);

public:
  SNstream(char* nm) : SNunit("stream")
    {
      name = nm;
      n_order = 0;
      topOrder = 0;
      inletApp = OFF;
    }
  ~SNstream() { delete name; }
  void print(ostream& ost) { ost << name; }
  char* get_name() { return name; }
  int get_n_order() { return n_order; }
  gList(orderCount)& get_appearances() { return appearances; }
  int count(int);
  void uncount(int);
  void print_rc();
  OnOff isSink() { return !inletApp; }
  void split(int n) { split(ORD_OUTLET, n); }
  void split(int ord, int n) { findOrMakeOrderCount(ord)->split += n; }
  void bindInletAndTopOutlet();
  bool isUnusedVars();

  //
  // Methods for encoding
  //
  Rind createJoints(int, instList&);
  Rind regno(int);
  Rind regno() { return regno(ORD_OUTLET); }
  void setRegno(int, Rind);
  void setRegno(Rind r) { return setRegno(ORD_OUTLET, r); }
  Rind encode(instList& code) { return encode(ORD_OUTLET, code); }
  Rind encode(int, instList&);
  Rind encodeDestination(instList&, int);
  void encodeAsSelectorArg(Rind pos, instList& code) {
    encodeAsSelectorArg(ORD_OUTLET, pos, code);
  }
  void encodeAsSelectorArg(int, Rind, instList&);
};

#endif SNstream
