/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include <assert.h>
#include "Name.h"
#include "RegTable.h"
#include "SNstream.h"
#include "SNerror.h"
#include "errmsg.h"
#include "CDcsink.h"
#include "CDcmj.h"
#include "CDsplit_n.h"
#include "CDcaj.h"
#include "CDconnect.h"
#include "PIcomment.h"

orderCount* SNstream::find(int ord)
{
  gList_iterator(orderCount) ocit(&appearances);
  for (orderCount* oc = ocit() ; oc ; oc = ocit.next()) {
    if (oc->order == ord) return oc;
    if (oc->order > ord) break;
  }
  return 0;
}

orderCount* SNstream::findOrMakeOrderCount(int ord)
{
  gList_iterator(orderCount) ocit(&appearances);
  for (orderCount* oc = ocit() ; oc ; oc = ocit.next()) {
    if (oc->order == ord) return oc;
    if (oc->order > ord) break;
  }
  orderCount* new_oc = new orderCount(ord);
  appearances.insert(ocit.index(), new_oc);
  n_order++;
  return new_oc;
}

int SNstream::count(int ord)
{
  if (ord == ORD_INLET) {	// inlet ξ
    if (inletApp) return -1;	// ǤinletƤ硣
    inletApp = ON;
  }
  else if (ord > ORD_INLET) {	// outlet ξ
    if (topOrder == 0 ||	// ޤĤ⵭ϿƤʤ
	ord < topOrder) {	// ⤤̤Ĥä
      topOrder = ord;
    }
  }
  else assert(FALSE);		// ï㤤Ƥ(ord < ORD_INLET)
  return ++(findOrMakeOrderCount(ord)->count);
}

void SNstream::uncount(int ord)
{
  assert(ord >= ORD_INLET);
  orderCount* ocp = find(ord);
  assert(ocp != 0);
  --(ocp->count);
  if (ocp->count == 0) {
    gList_iterator(orderCount) oclItr(&appearances);
    if (topOrder == ord) {
      orderCount* ocp2 = oclItr.next();
      if (ocp2) topOrder = ocp2->order;
      else topOrder = 0;
      oclItr.reset();
    }
    oclItr.find(ocp);
    oclItr.remove();
  }
  if (ord == ORD_INLET) {
    assert(inletApp == ON);
    inletApp = OFF;
  }
}

void SNstream::print_rc()
{
  cout << name << ":\n";
  cout << "Number of orders:" << n_order << "\n";
  gList_iterator(orderCount) ocit(&appearances);
  for (orderCount* oc = ocit() ; oc ; oc = ocit.next()) {
    if (oc->order == 0) {
      cout << "	 ^" << name << ":\n";
    }
    else {
      cout << "	 " << name << "$" << oc->order << ":\n";
    }
    cout << "\tcount : " << oc->count << "\n";
    cout << "\tsplit : " << oc->split << "\n";
  }
}

// void SNstream::markSink()
// {
//   gList_iterator(orderCount) ocit(&appearances);
//   if (ocit()->order != ORD_INLET) setSink();
// }

void SNstream::bindInletAndTopOutlet()
{
  if (inletApp && topOrder != 0) {
    gList_iterator(orderCount) ocit(&appearances);
    orderCount* inlet = ocit();
    orderCount* top = ocit.next();
    // top->count += inlet->count; Ϥ⤦ɬפʤ
  }
  else if (inletApp) {
    gList_iterator(orderCount) ocit(&appearances);
    orderCount* inlet = ocit();
    // topOrder = ORD_OUTLET;
    // ιԤνԤƤ롣
    orderCount* top = findOrMakeOrderCount(ORD_OUTLET);
    // top->count = inlet->count;   // ORD_INLET εϿ
  }				// topOrder εϿȤƻȤ
}

Rind SNstream::regno(int order)
{
  orderCount* ocp = find(order);
  return ocp ? ocp->regno : -1;
}

void SNstream::setRegno(int order, Rind r)
{
  orderCount* ocp = find(order);
  assert(ocp);
  ocp->regno = r;
  regTable.set(r, ocp->count, OnOff(ocp->split < 1));
}

Rind SNstream::encodeDestination(instList& code, int ln)
{
  if (!inletApp) {
    Rind Rsink = regTable.newReg();
    regTable.set(Rsink, 1);
    code.add(new CDcreate_sink(Rsink));
    return Rsink;
  }
  Rind r = regno(ORD_OUTLET);
  if (r >= 0) {
    if (regTable.isLastAppearance(r)) {
      orderCount* ocp = findOrMakeOrderCount(ORD_OUTLET);
      if (ocp->count > 1) {
	sprintf(ErrorMessageBuffer,
		"register R%d may have been destroyed",
		r);
	code.add(new PIcomment(ErrorMessageBuffer));
	sprintf(ErrorMessageBuffer,
		"warning: sorry, variable '%s' may be garbled here",
		name);
	SNwarning(ErrorMessageBuffer, ln);
	return r;
      }
    }
    return r;
  }
  return createJoints(ORD_OUTLET, code);
}

Rind SNstream::encode(int order, instList& code)
{
  Rind r = regno(order);
  if (r >= 0) return r;
  if (inletApp || order != topOrder) return createJoints(order, code);
  Rind Rsink = regTable.newReg();
  regTable.set(Rsink);
  code.add(new CDcreate_sink(Rsink));
  if (appearances.length() > 1) { // ʣν̤outlet롣
    r = createJoints(order, code);
    code.add(new CDconnect(Rsink, r));
    // Ǥ $sink Ȥ³ϥץ˸ƤʤΤʤΤǡ
    // ԤΤ褦inletʬνиȤ򸺤餹ɬפϤʤ
    // autoClose(r, code);
  }
  else {			// outlet ν̤ϰĤʤ
    orderCount* ocp = find(order);
    regTable.add(Rsink, ocp->count, OnOff(ocp->split < 1));
    if (ocp->split > 1) {
      code.add(new CDsplit_n(Rsink, ocp->split - 1));
    }
    ocp->regno = Rsink;
  }
  return Rsink;
}

Rind SNstream::createJoints(int from, instList& code)
{
  gList(orderCount) targets;
  gList_iterator(orderCount) ocit(&appearances);
  for (orderCount* ocp = ocit() ; ocp ; ocp = ocit.next()) {
    if (ocp->order < from) continue;
    if (ocp->regno >= 0) break;
    targets.push(ocp);
  }
  Rind Rlow;
  if (ocp && ocp->regno >=0) {
    Rlow = ocp->regno;
  }
  else {
    ocp = targets.pop();
    Rlow = ocp->regno = regTable.newReg();
    regTable.set(Rlow, ocp->count, OnOff(ocp->split < 1));
    regTable.increment(Rlow);	// ̤inletʬ
    code.add(new CDcreate_mjoint(Rlow));
    if (ocp->split > 1) {
      code.add(new CDsplit_n(Rlow, ocp->split - 1));
    }
  }
  for (ocp = targets.pop(); ocp ; ocp = targets.pop()) {
    Rind Rhigh = ocp->regno = regTable.newReg();
    regTable.set(Rhigh, ocp->count, OnOff(ocp->split < 1));
    regTable.increment(Rhigh);	// ̤inletʬ
    code.add(new CDcreate_ajoint(Rhigh, Rlow));
    if (ocp->split > 1) {
      code.add(new CDsplit_n(Rhigh, ocp->split - 1));
    }
    autoClose(Rlow, code);	// create_ajoint񤹤inletʬ
    Rlow = Rhigh;
  }
  return Rlow;
}

void SNstream::encodeAsSelectorArg(int order, Rind pos, instList& code)
{
  Rind r = regno(order);
  if (r >= 0) {
    code.add(new CDconnect(r, pos));
    autoClose(pos, code);
    regTable.decrement(r);
    return;
  }
  orderCount* ocp = appearances.last(); // ocp Ϥѿκorderξ
  if (ocp && ocp->order == order && ocp->count == 1) {
    // Ϳ줿orderǡġ
    // и1ʤС
    ocp->regno = pos; // 쥸ͤ򤽤ΤޤѿͤȤƻġ
    regTable.set(pos, ocp->count, OnOff(ocp->split < 1));
    return;
  }
  r = encode(order, code);
  code.add(new CDconnect(r, pos));
  autoClose(pos, code);
  regTable.decrement(r);
}

bool SNstream::isUnusedVars()
{
  return (inletApp && appearances.length() <= 1);
}
