/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-
/* $Id: SNsoslot.h,v 1.4 1991/06/26 00:40:56 konishi Exp konishi $
 *
 */

#ifndef SNsoslot_h
#define SNsoslot_h 1

#include <stream.h>
#include "SNunit.h"
#include "SNname.h"

class instList;
class SNname;

class SNsoslot : public SNunit {
  SNname& name;
  SNunit* value;

public:
  SNsoslot(SNname*, SNunit*);
  ~SNsoslot() { delete &name; }
  void print(ostream& ost) {
    ost << value << " = !" << name;
  }
  void split(int n) { value->split(n + 1); }
  Rind encode(instList&);
};

inline SNsoslot::SNsoslot(SNname* nm, SNunit* v)
: SNunit("soslot"), value(v), name(*nm) {}

#endif SNsoslot_h

