/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNsioslot_h
#define SNsioslot_h 1

#include <stream.h>
#include "SNname.h"
#include "SNunit.h"

class instList;
class SNname;

class SNsioslot : public SNunit {
  SNname& iname;		    // inlet slot name
  SNname& oname;		    // outlet slot name

public:
  SNsioslot(SNname* n1, SNname* n2)
    : SNunit("sioslot"), iname(*n1), oname(*n2) {}
  ~SNsioslot() { delete &iname; delete &oname; }
  void print(ostream& ost) {
    ost << "@" << iname << " = !" << oname;
  }
  void split(int n) {}
  void encodeAtGround(instList&);
};

#endif SNsioslot_h

