/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNshtl_h
#define SNshtl_h 1

#include "SNbinop.h"
#include "CDshtl.h"

struct SNshtl : SNbinop {
  SNshtl(SNunit* a1, SNunit* a2) : SNbinop("<<", a1, a2) {}
  char* opName() { return "<<"; }

  void encodeMessageSending(Rind r1, Rind r2, Rind r3, instList& code) {
    code.add(new CDshtl(r1, r2, r3));
  }
};

#endif SNshtl_h
