/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-
/* $Id: SNseto.h,v 1.4 1991/07/02 04:43:32 konishi Exp konishi $
 *
 */

#ifndef SNseto_h
#define SNseto_h 1

#include "SNunit.h"

class SNseto : public SNunit {
  SNunit* arg1;			// array
  SNunit* arg2;			// index
  SNunit* arg3;			// value set

public:
  SNseto(SNunit* a, SNunit* b, SNunit* c)
    : SNunit("seto"), arg1(a), arg2(b), arg3(c) {}
  void print(ostream& ost) {
    // Y = X[I]
    ost << arg3 << " = " << arg1 << "[" << arg2 << "]";
  }
  void split(int n) { arg1->split(1); arg2->split(1); arg3->split(n + 1); }
  Rind encode(instList&);
};

#endif SNseto_h
