/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-
/* $Id: SNseti.h,v 1.3 1991/06/26 00:40:56 konishi Exp konishi $
 *
 */

#ifndef SNseti_h
#define SNseti_h 1

#include "SNunit.h"
#include "CDseti.h"

class SNseti : public SNunit {
  SNunit* arg1;			// array
  SNunit* arg2;			// index
  SNunit* arg3;			// value set

public:
  SNseti(SNunit* a, SNunit* b, SNunit* c)
    : SNunit("seti"), arg1(a), arg2(b), arg3(c) {}
  void print(ostream& ost) {
    // X :set(I, ^Y)
    ost << arg1 << ":set(" << arg2 << ", " << arg3 << ")"
  }
  void split(int n) { arg1->split(n); arg2->split(1); arg3->split(1); }
  Rind encode(Rind r1, Rind r2, Rind r3, instList& code) {
    code.add(new CDseti(r1, r2, r3));
  }
};

#endif SNseti_h
