/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include "intList.h"
#include "RegTable.h"
#include "SNsendself.h"
#include "SNmethod.h"
#include "Protocol.h"
#include "inst.h"
#include "CDsend_self.h"
#include "CDget_self.h"
#include "CDsplit_n.h"
#include "CDlabel.h"
#include "CDdescend.h"
#include "MovTable.h"
#include "SNmsgArray.h"
#include "nameStream.h"
#include "SNtree.h"
#include "SNtcs.h"

SNsendself::SNsendself(int n) : SNunit("send self"), messages(n)
{
  splitCount = 0;
}

SNsendself::~SNsendself() { delete &messages; }

SNmessage*& SNsendself::arg(int i) { return messages[i]; }

void SNsendself::print(ostream& ost)
{
  SNmessageArrayItr messageItr(messages);
  SNmessage* msgp = messageItr();
  msgp->print(ost);
  for (msgp = messageItr.next() ; msgp ; msgp = messageItr.next()) {
    ost << " ";
    msgp->print(ost);
  }
}

void SNsendself::split(int n)
{
  splitCount = n;
  messages.split();
}

void SNsendself::encodeAtGround(instList& code)
{
  // Υå˰encode
  // sendself ΥɤĤäƥå˥ץå夹롣
  instList codeStack;
  SNmessageArrayItr messageItr(messages);
  for (SNmessage* msgp = messageItr() ; msgp ; msgp = messageItr.next()) {
    intList* argRinds = msgp->encodeArgs(code);
    Name msgname = msgp->protocol()->string();
    CDsend_self* sendselfp = new CDsend_self(msgname, argRinds);
    codeStack.push(sendselfp);
  }

  // å sendself ΰclose롣
  instListItr sendings(&codeStack);
  for (CDsend_self* sendselfp = (CDsend_self*)sendings() ; sendselfp ;
       sendselfp = (CDsend_self*)sendings.next()) {
    sendselfp->autoClose(code);
  }

  //  continuation åꡢ
  // continuation å륳ɤФ
  MovTable* movTablep = new MovTable(regTable);
  movTablep->fold(0);
  intList* argRinds = movTablep->argList();
#ifdef IOSTREAM_2_0
  ostrstream nameStream(namebuffer, bufsize);
#else
  ostream nameStream(bufsize, namebuffer);
#endif
  nameStream << "cont"
    << ++SNtree::currentMethod->numberOfSendselves;
  treeContextStack.printPathByIndex(nameStream);
  nameStream.put('\0');
  SNname contpcol(namebuffer, EMescaped);
  Protocol* ipp = Protocol::intern(contpcol, argRinds->length());
  Name contname = ipp->string();
  sendselfp = new CDsend_self(contname, argRinds);
  code.add(sendselfp);

  // θ塢å饳ɤȤФ
  // ˽Ϥ˰θ򤹤롣
  sendings.reset();
  for (sendselfp = (CDsend_self*)sendings() ; sendselfp ;
       sendselfp = (CDsend_self*)sendings.next()) {
    code.add(sendselfp);
  }

  // descend 롣
  code.add(new CDdescend());

  // continuation ᥽åɤȥ٥֤
  ipp->addPImethod(code);
  code.add(new CDlabel(contname));

  // Ǹ򤷤쥸ΰ֤롣
  movTablep->encodeUnfolding(code);
}
