/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include "SNsend.h"
#include "Protocol.h"
#include "intList.h"
#include "CDsend.h"
#include "CDget_self.h"

Rind SNsend::encode(instList& code)
{
  Rind Rdest = dest->encodeDestination(code);
  intList* argRinds = msg->encodeArgs(code);
  Name msgname = msg->protocol()->string();
  code.add(new CDsend(Rdest, msgname, argRinds));
  intListItr argRs(*argRinds);
  for (Rind r = argRs() ; r ; r = argRs.next()) {
    autoClose(r - 1, code);	// SNmessage::encodeArgs() Υ
  }				// бƤ롣
  return Rdest;
}
