/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNscdro_h
#define SNscdro_h 1

#include "SNunit.h"

class SNscdro : public SNunit {
  SNunit* arg1;			// List
  SNunit* arg2;			// value

public:
  SNscdro(SNunit* a, SNunit* b)
    : SNunit("scdro"), arg1(a), arg2(b) {}
  void print(ostream& ost) {
    // Y = cdr X
    ost << arg2 << " = cdr " << arg1;
  }
  void split(int n) { arg1->split(1); arg2->split(n + 1); }
  Rind encode(instList&);
};

#endif SNscdro_h
