/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-
/* $Id: SNscari.h,v 1.3 1991/06/26 00:40:56 konishi Exp konishi $
 *
 */

#ifndef SNscari_h
#define SNscari_h 1

#include "SNunit.h"
#include "CDsetcari.h"

class SNscari : public SNunit {
  SNunit* arg1;			// List
  SNunit* arg2;			// value

public:
  SNscari(SNunit* a, SNunit* b)
    : SNunit("scari"), arg1(a), arg2(b) {}
  void print(ostream& ost) {
    // X :setcar(^Y)
    ost << arg1 << ":setcar(" << arg2;
  }
  void split(int n) { arg1->split(n); arg2->split(1); }
  Rind encode(Rind r1, Rind r2, instList& code) {
    code.add(new CDsetcari(r1, r2));
  }
};

#endif SNscari_h
