/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-
/* $Id: SNscar.h,v 1.2 1991/06/26 00:40:56 konishi Exp konishi $
 *
 */

#ifndef SNscar_h
#define SNscar_h 1

#include "SNunit.h"
#include "SNsetcaro.h"

class SNscar : public SNunit {
  SNunit* arg1;
  SNunit* arg2;

public:
  SNscar(SNunit* a, SNunit* b)
    : SNunit("set_car"), arg1(a), arg2(b) {}
  void print(ostream& ost) {
    ost << arg2 << " = car " << arg1;
  }
  void split() { arg1->split(0); arg2->split(0); }
  Rind encode(Rind r1, Rind r2, instList& code) {
    code.add(new CDsetcaro(r1, r2));
  }
};

#endif SNscar_h
