/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNplain_h
#define SNplain_h 1

#include "SNunit.h"
#include "SNstream.h"

class instList;
class SNstreamList;

class SNplain : public SNunit {
  char* name;
  SNstream* stream;
public:
  SNplain(char* n) : SNunit("plain"), stream(0) {
    name = fresh_string(n);
  }
  void setStream(SNstream* s) { stream = s; }
  SNstream* Stream() { return stream; }
  char* Name() { return name; }
  void print(ostream& ost) { ost << name; }
  void split(int n) { stream->split(ORD_OUTLET, n); }
  Rind encode(instList& code) { return stream->encode(ORD_OUTLET, code); }
  Rind encodeDestination(instList& code) {
    return stream->encodeDestination(code, LineNumber());
  }
  void encodeAsSelectorArg(Rind pos, instList& code) {
    stream->encodeAsSelectorArg(ORD_OUTLET, pos, code);
  }

  Rind regno() { return stream->regno(); }
  void setRegno(Rind r) { return stream->setRegno(ORD_OUTLET, r); }

  static SNplain* create(char*, SNstreamList*);
};

#endif SNplain_h
