/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include <stream.h>
#include <string.h>
#include "RegTable.h"
#include "SNname.h"
#include "SNoslot.h"
#include "inst.h"
#include "CDsetoutlet.h"
#include "CDgetoutlet.h"
#include "CDsplit_n.h"

SNoslot::SNoslot(SNname* nm) : SNunit("oslot"), name(*nm) {}

Rind SNoslot::encode(instList& code)
{
  Rind r = regTable.newReg();
  regTable.set(r, 1, OnOff(splitCount < 1));
  code.add(new CDget_outlet(r, name));
  if (splitCount > 1) {
    code.add(new CDsplit_n(r, splitCount - 1));
  }
  return r;
}

Rind SNoslot::connectTo(Rind outlet, instList& code)
{
  code.add(new CDset_outlet(outlet, name));
  return outlet;
}

