/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNorder_h
#define SNorder_h 1

#include "SNunit.h"
#include "SNstream.h"

class instList;
class SNstreamList;

class SNorder : public SNunit {
  char* name;
  SNstream* stream;
  int order;
public:
  SNorder(char* n, int ord) : SNunit("order") {
    name = fresh_string(n);
    stream = 0;
    order = ord;
  }
  SNorder(SNstream* s, int ord) : SNunit("order") { stream = s; order = ord; }
  void setStream(SNstream* s) { stream = s; }
  void print(ostream&);
  void split(int n) { stream->split(order, n); }
  Rind encode(instList& code) { return stream->encode(order, code); }
  void encodeAsSelectorArg(Rind pos, instList& code) {
    stream->encodeAsSelectorArg(order, pos, code);
  }

  Rind regno() { return stream->regno(); }
  void setRegno(Rind r) { return stream->setRegno(order, r); }

  static SNorder* create(char*, int, SNstreamList*);
};

#endif SNorder_h
