/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include "CDcinstance.h"	// Create instance
#include "CDclocinst.h"		// Create local instance
#include "SNname.h"
#include "SNnew.h"

SNnew::SNnew(SNname* nm, enum cite loc)
: SNliteral("new"), location(loc)
{
  newClass = Classref::intern(*nm);
  delete nm;
}

void SNnew::encodeCreation(Rind r, instList& code)
{
  Name className = newClass->string();
  if (location == external) {
    code.add(new CDcreate_instance(r, className));
  }
  else {
    code.add(new CDcreate_local_instance(r, className));
  }
  Classref* cp = newClass->intern();
  if (cp != newClass) { delete newClass; newClass = cp; }
}
