/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNnequal_h
#define SNnequal_h 1

#include "SNbincond.h"
#include "CDif_equal.h"
#include "CDnequal.h"

class SNnequal : public SNbincond {
  virtual char* opName() { return "!="; }
  virtual void addDirectJump(Rind r1, Rind r2, char* t, char* f,
			     instList& code) {
    code.add(new CDif_equal(r1, r2, f, t));
  }
  virtual void encodeMessageSending(Rind r1, Rind r2, Rind r3,
				    instList& code) {
    code.add(new CDnequal(r1, r2, r3));
  }

public:
  SNnequal(SNunit* a1, SNunit* a2) : SNbincond("!=", a1, a2) {}
};

#endif SNnequal_h
