/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#ifndef SNname_h
#define SNname_h 1

#include <stream.h>
#include <string.h>
#include <bool.h>
#include "Name.h"

typedef enum {EMnormal, EMescaped} SNnameEscapeMode;

class SNname : public Name {
  SNnameEscapeMode escapeMode;
  int lineNumber;

  bool needEscape();

public:
  SNname(char*, SNnameEscapeMode = EMnormal);
  ~SNname() {}

  char* nameInCode() const;
  void LineNumber(int i) { lineNumber = i; }
  int LineNumber() { return lineNumber; }
  operator char*() const { return nameInCode(); }
  char* trueName() const {
    return form("%s", this->Name::operator char*());
  }
  friend ostream& operator<< (ostream& ost, SNname& n) {
    ost << n.nameInCode();
    return ost;
  }
  friend bool operator==(SNname& a, SNname& b)
    { return (strcmp(a, b) == 0); }
};

#endif SNname_h
