/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		       Author: Koichi Konishi (konishi@csl.cl.nec.co.jp) -*/
// This may look like C code, but it is really -*- C++ -*-

#include "ctype.h"
#include "Name.h"
#include "SNname.h"

SNname::SNname(char* s, SNnameEscapeMode mode = EMnormal) : Name(s)
{
  escapeMode = mode;
  lineNumber = 0;
  if (escapeMode == EMescaped && !needEscape()) {
    escapeMode = EMnormal;
  }
}

char* SNname::nameInCode() const
{
  if (escapeMode == EMnormal) {
    return form("%s", this->Name::operator char*());
  }
  Name tmp = escape('\'', '\'');
  return form("'%s'", (char*)tmp);
}

bool SNname::needEscape()
{
  const char* s = this->Name::operator char*();
  if (islower(*s)) s++;
  else return TRUE;
  while (isalnum(*s) || *s == '_') s++;
  if (*s == '\0') return FALSE;
  else return TRUE;
}
